--[[
DewDropDown.lua
Defines the table listings for the dropdown lists.
]]

--Invoke all libraries
local BabbleBoss = AceLibrary("Babble-Boss-2.2");
local BabbleZone = AceLibrary("Babble-Zone-2.2");
local BabbleFaction = AceLibrary("Babble-Faction-2.2");
local BabbleClass = AceLibrary("Babble-Class-2.2");
local BabbleTrade=AceLibrary("Babble-Tradeskill-2.2");
local AL = AceLibrary("AceLocale-2.2"):new("AtlasLoot");

--This is a multi-layer table defining the main loot listing.
--Entries have the text to display, loot table or sub table to link to and if the link is to a loot table or sub table
AtlasLoot_DewDropDown = {
	[1] = {
        [BabbleZone["Eastern Kingdoms"]] = {
            [1] = { 
                { BabbleZone["Blackrock Depths"], "BlackrockDepths", "Submenu" },
            },
            [2] = { 
                { BabbleZone["Lower Blackrock Spire"], "LowerBlackrock", "Submenu" },
            },
            [3] = { 
                { BabbleZone["Upper Blackrock Spire"], "UpperBlackrock", "Submenu" },
            },
            [4] = { 
                { BabbleZone["Blackwing Lair"], "BlackwingLair", "Submenu" },
            },
            [5] = { 
                { BabbleZone["The Deadmines"], "Deadmines", "Submenu" },
            },
            [6] = { 
                { BabbleZone["Gnomeregan"], "Gnomeregan", "Submenu" },
            },
            [7] = { 
                { BabbleZone["Karazhan"], "Karazhan", "Submenu" },
            },
            [8] = { 
                { BabbleZone["Molten Core"], "MoltenCore", "Submenu" },
            },
            [9] = { 
                { BabbleZone["Naxxramas"], "Naxxramas", "Submenu" },
            },
            [10] = { 
                { BabbleZone["Scarlet Monastery"], "Scarlet Monastery", "Submenu" },
            },
            [11] = { 
                { BabbleZone["Scholomance"], "Scholomance", "Submenu" },
            },
            [12] = { 
                { BabbleZone["Shadowfang Keep"], "ShadowfangKeep", "Submenu" },
            },
            [13] = { 
                { BabbleZone["The Stockade"], "TheStockade", "Submenu" },
            },
            [14] = { 
                { BabbleZone["Stratholme"], "Stratholme", "Submenu" },
            },
            [15] = { 
                { BabbleZone["The Temple of Atal'Hakkar"], "SunkenTemple", "Submenu" },
            },
            [16] = { 
                { BabbleZone["Uldaman"], "Uldaman", "Submenu" },
            },
            [17] = { 
                { BabbleZone["Zul'Gurub"], "ZulGurub", "Submenu" },
            },
        },
    },
    [2] = {
        [BabbleZone["Kalimdor"]] = {
            [1] = { 
                { BabbleZone["Blackfathom Deeps"], "BlackfathomDeeps", "Submenu" },
            },
            [2] = { 
                [BabbleZone["Caverns of Time"]] = {
                    { BabbleZone["Old Hillsbrad Foothills"], "CoTOldHillsbrad", "Submenu" },
                    { BabbleZone["The Black Morass"], "CoTBlackMorass", "Submenu" },
                    { BabbleZone["Hyjal Summit"], "CoTHyjal", "Submenu" },
                }, 
            },
            [3] = { 
                [BabbleZone["Dire Maul"]] = {
                    { BabbleZone["Dire Maul (East)"], "DireMaulEast", "Submenu" },
                    { BabbleZone["Dire Maul (West)"], "DireMaulWest", "Submenu" },
                    { BabbleZone["Dire Maul (North)"], "DireMaulNorth", "Submenu" },
                }, 
            },
            [4] = { 
                { BabbleZone["Maraudon"], "Maraudon", "Submenu" },
            },
            [5] = { 
                { BabbleZone["Onyxia's Lair"], "Onyxia", "Submenu" },
            },
            [6] = { 
                { BabbleZone["Ragefire Chasm"], "RagefireChasm", "Submenu" },
            },
            [7] = { 
                { BabbleZone["Razorfen Downs"], "RazorfenDowns", "Submenu" },
            },
            [8] = { 
                { BabbleZone["Razorfen Kraul"], "RazorfenKraul", "Submenu" },
            },
            [9] = { 
                { BabbleZone["Ruins of Ahn'Qiraj"], "RuinsofAQ", "Submenu" },
            },
            [10] = { 
                { BabbleZone["Temple of Ahn'Qiraj"], "TempleofAQ", "Submenu" },
            },
            [11] = { 
                { BabbleZone["Wailing Caverns"], "WailingCaverns", "Submenu" },
            },
            [12] = { 
                { BabbleZone["Zul'Farrak"], "ZulFarrak", "Submenu" },
            },
        },
    },
    [3] = {
        [BabbleZone["Outland"]] = {
            [1] = { 
                [BabbleZone["Auchindoun"]] = {
                    { BabbleZone["Mana-Tombs"], "AuchManaTombs", "Submenu" },
                    { BabbleZone["Auchenai Crypts"], "AuchCrypts", "Submenu" },
                    { BabbleZone["Sethekk Halls"], "AuchSethekk", "Submenu" },
                    { BabbleZone["Shadow Labyrinth"], "AuchShadowLab", "Submenu" },
                }, 
            },
            [2] = { 
                { BabbleZone["Black Temple"], "BlackTemple", "Submenu" },
            },
            [3] = { 
                [BabbleZone["Coilfang Reservoir"]] = {
                    { BabbleZone["The Slave Pens"], "CFRSlavePens", "Submenu" },
                    { BabbleZone["The Underbog"], "CFRUnderbog", "Submenu" },
                    { BabbleZone["The Steamvault"], "CFRSteamvault", "Submenu" },
                    { BabbleZone["Serpentshrine Cavern"], "CFRSerpentshrine", "Submenu" },
                }, 
            },
            [4] = { 
                { BabbleZone["Gruul's Lair"], "Gruul", "Submenu" },
            },
            [5] = { 
                [BabbleZone["Hellfire Citadel"]] = {
                    { BabbleZone["Hellfire Ramparts"], "HCRamparts", "Submenu" },
                    { BabbleZone["The Blood Furnace"], "HCFurnace", "Submenu" },
                    { BabbleZone["The Shattered Halls"], "HCShatteredHalls", "Submenu" },
                    { BabbleZone["Magtheridon's Lair"], "HCMagLair", "Submenu" },
                }, 
            },
            [6] = { 
                [BabbleZone["Tempest Keep"]] = {
                    { BabbleZone["The Mechanar"], "TKMech", "Submenu" },
                    { BabbleZone["The Botanica"], "TKBot", "Submenu" },
                    { BabbleZone["The Arcatraz"], "TKArc", "Submenu" },
                    { BabbleZone["The Eye"], "TKEye", "Submenu" },
                }, 
            },
        },
    },
    [4] = {
        [AL["Sets/Collections"]] = {
            [1] = { 
                { AL["Arena PvP Sets"], "ArenaPvPArmor", "Submenu" },
            },
            [2] = { 
                { AL["Arena 2 PvP Sets"], "Arena2PvPArmor", "Submenu" },
            },
            [3] = { 
                [AL["Crafted Sets"]] = {
                    { BabbleTrade["Blacksmithing"], "CraftSetBlacksmith", "Submenu" },
                    { BabbleTrade["Leatherworking"], "CraftSetLeatherwork", "Submenu" },
                    { BabbleTrade["Tailoring"], "CraftSetTailor", "Submenu" },
                }, 
            },
            [4] = { { AL["Crafted Epic Weapons"], "CraftedWeapons1", "Table" }, },
            [5] = { 
                { AL["Dungeon 1/2 Sets"], "DungeonSets12", "Submenu" },
            },
            [6] = { 
                { AL["Dungeon 3 Sets"], "DungeonSets3", "Submenu" },
            },
            [7] = { { AtlasLoot_TableNames["HardModeToken"][1], "HardModeToken", "Table" }, },
            [8] = { { AtlasLoot_TableNames["HardModeToken3"][1], "HardModeToken3", "Table" }, },
            [9] = { { AtlasLoot_TableNames["HardModeToken2"][1], "HardModeToken2", "Table" }, },
            [10] = { { AL["Legendary Items"], "Legendaries", "Table" }, },
            [11] = { 
                { AL["Pre 60 Sets"], "Pre60Sets", "Submenu" },
            },
            [12] = { 
                { AL["PvP Sets (Level 60)"], "Lvl60PvPArmor", "Submenu" },
            },
            [13] = { 
                { AL["PvP Sets (Level 70)"], "Lvl70PvPArmor", "Submenu" },
            },
            [14] = { { AL["Rare Mounts"], "RareMounts", "Table" }, },
            [15] = { 
                { AL["Ruins of Ahn'Qiraj Sets"], "RuinsofAQSets", "Submenu" },
            },
            [16] = { { AL["Tabards"], "Tabards1", "Table" }, },
            [17] = { 
                { AL["Temple of Ahn'Qiraj Sets"], "TempleofAQSets", "Submenu" },
            },
            [18] = { 
                { AL["Tier 1 Sets"], "T1Sets", "Submenu" },
            },
            [19] = { 
                { AL["Tier 2 Sets"], "T2Sets", "Submenu" },
            },
            [20] = { 
                { AL["Tier 3 Sets"], "T3Sets", "Submenu" },
            },
            [21] = { 
                { AL["Tier 4 Sets"], "T4Sets", "Submenu" },
            },
            [22] = { 
                { AL["Tier 5 Sets"], "T5Sets", "Submenu" },
            },
            [23] = { 
                { AL["Tier 6 Sets"], "T6Sets", "Submenu" },
            },
            [24] = { 
                { AL["Zul'Gurub Sets"], "ZGSets", "Submenu" },
            },
            [25] = { { AL["Upper Deck Card Game Items"], "CardGame1", "Table" }, },
        },
    },
    [5] = {
        [AL["PvP Rewards"]] = {
            [1] = { 
                { AL["Arena PvP Sets"], "ArenaPvPRewards", "Submenu" },
            },
            [2] = { 
                { AL["Arena 2 PvP Sets"], "Arena2PvPRewards", "Submenu" },
            },
            [3] = { 
                { BabbleZone["Alterac Valley"], "AVRewards", "Submenu" },
            },
            [4] = { 
                { BabbleZone["Arathi Basin"], "ABRewards", "Submenu" },
            },
            [5] = { 
                { AL["Arathi Basin Sets"], "ABSets", "Submenu" },
            },
            [6] = { { AtlasLoot_TableNames["Hellfire"][1], "Hellfire", "Table" }, },
            [7] = { { AtlasLoot_TableNames["Nagrand1"][1], "Nagrand1", "Table" }, },
            [8] = { 
                { AL["PvP Accessories (Level 60)"], "PvPLvl60Access", "Submenu" },
            },
            [9] = { 
                { AL["PvP Accessories (Level 70)"], "PvPLvl70Access", "Submenu" },
            },
            [10] = { 
                { AL["PvP Non-Set Epics"], "PvPNonSetEpic", "Submenu" },
            },
            [11] = { 
                { AL["PvP Rewards (Level 60)"], "PvPLvl60Rewards", "Submenu" },
            },
            [12] = { 
                { AL["PvP Rewards (Level 70)"], "PvPLvl70Rewards", "Submenu" },
            },
            [13] = { { AtlasLoot_TableNames["Terokkar"][1], "Terokkar", "Table" }, },
            [14] = { 
                { BabbleZone["Warsong Gulch"], "WSGRewards", "Submenu" },
            },
            [15] = { { AtlasLoot_TableNames["Zangarmarsh"][1], "Zangarmarsh", "Table" }, },
        },
    },
    [6] = {
        { AL["World Bosses"], "WorldBosses", "Submenu" },
    },
    [7] = {
        { AL["Reputation Factions"], "Factions", "Submenu" },
    },
    [8] = {
        { AL["World Events"], "WorldEvents", "Submenu" },
    },
};

--This table defines all the subtables needed for the full menu
--Each sub table entry contains the text entry and the loot table that goes wih it
AtlasLoot_DewDropDown_SubTables = {
    ["BlackrockDepths"] = {
        { AtlasLoot_TableNames["BRDPyron"][1], "BRDPyron" },
        { BabbleBoss["Lord Roccor"], "BRDLordRoccor" },
        { BabbleBoss["High Interrogator Gerstahn"], "BRDHighInterrogatorGerstahn" },
        { AtlasLoot_TableNames["BRDArena"][1], "BRDArena" },
        { AL["Theldren"], "BRDTheldren" },
        { BabbleBoss["Houndmaster Grebmar"], "BRDHoundmaster" },
        { AtlasLoot_TableNames["BRDPyromantLoregrain"][1], "BRDPyromantLoregrain" },
        { AL["The Vault"], "BRDTheVault" },
        { BabbleBoss["Warder Stilgiss"], "BRDWarderStilgiss" },
        { BabbleBoss["Verek"], "BRDVerek" },
        { BabbleBoss["Fineous Darkvire"], "BRDFineousDarkvire" },
        { BabbleBoss["Lord Incendius"], "BRDLordIncendius" },
        { BabbleBoss["Bael'Gar"], "BRDBaelGar" },
        { BabbleBoss["General Angerforge"], "BRDGeneralAngerforge" },
        { BabbleBoss["Golem Lord Argelmach"], "BRDGolemLordArgelmach" },
        { AtlasLoot_TableNames["BRDGuzzler"][1], "BRDGuzzler" },
        { BabbleBoss["Ambassador Flamelash"], "BRDFlamelash" },
        { BabbleBoss["Panzor the Invincible"], "BRDPanzor" },
        { AtlasLoot_TableNames["BRDTomb"][1], "BRDTomb" },
        { BabbleBoss["Magmus"], "BRDMagmus" },
        { BabbleBoss["Emperor Dagran Thaurissan"], "BRDImperatorDagranThaurissan" },
        { BabbleBoss["Princess Moira Bronzebeard"], "BRDPrincess" },
        { AtlasLoot_TableNames["BRDBSPlans"][1], "BRDBSPlans" },
        { AL["Trash Mobs"], "BRDTrash" },
        { AL["Set: The Gladiator"], "BLACKROCKD" },
    },
    ["LowerBlackrock"] = {
        { AtlasLoot_TableNames["LBRSSpirestoneButcher"][1], "LBRSSpirestoneButcher" },
        { BabbleBoss["Highlord Omokk"], "LBRSOmokk" },
        { AtlasLoot_TableNames["LBRSSpirestoneLord"][1], "LBRSSpirestoneLord" },
        { AtlasLoot_TableNames["LBRSLordMagus"][1], "LBRSLordMagus" },
        { BabbleBoss["Shadow Hunter Vosh'gajin"], "LBRSVosh" },
        { BabbleBoss["War Master Voone"], "LBRSVoone" },
        { AL["Mor Grayhoof"], "LBRSGrayhoof" },
        { AtlasLoot_TableNames["LBRSGrimaxe"][1], "LBRSGrimaxe" },
        { BabbleBoss["Mother Smolderweb"], "LBRSSmolderweb" },
        { BabbleBoss["Crystal Fang"], "LBRSCrystalFang" },
        { AtlasLoot_TableNames["LBRSDoomhowl"][1], "LBRSDoomhowl" },
        { AtlasLoot_TableNames["LBRSZigris"][1], "LBRSZigris" },
        { BabbleBoss["Halycon"], "LBRSHalycon" },
        { AtlasLoot_TableNames["LBRSSlavener"][1], "LBRSSlavener" },
        { AtlasLoot_TableNames["LBRSBashguud"][1], "LBRSBashguud" },
        { BabbleBoss["Overlord Wyrmthalak"], "LBRSWyrmthalak" },
        { AtlasLoot_TableNames["LBRSFelguard"][1], "LBRSFelguard" },
        { AL["Trash Mobs"], "LBRSTrash" },
        { AL["Set: Spider's Kiss"], "SpiderKiss" },
    },
    ["UpperBlackrock"] = {
        { BabbleBoss["Pyroguard Emberseer"], "UBRSEmberseer" },
        { BabbleBoss["Solakar Flamewreath"], "UBRSSolakar" },
        { AtlasLoot_TableNames["UBRSFLAME"][1], "UBRSFLAME" },
        { AtlasLoot_TableNames["UBRSRunewatcher"][1], "UBRSRunewatcher" },
        { BabbleBoss["Goraluk Anvilcrack"], "UBRSAnvilcrack" },
        { BabbleBoss["Warchief Rend Blackhand"], "UBRSRend" },
        { BabbleBoss["Gyth"], "UBRSGyth" },
        { BabbleBoss["The Beast"], "UBRSBeast" },
        { BabbleBoss["Lord Valthalak"], "UBRSValthalak" },
        { BabbleBoss["General Drakkisath"], "UBRSDrakkisath" },
        { AL["Trash Mobs"], "UBRSTrash" },
        { AL["Set: Dal'Rend's Arms"], "DalRend" },
    },
    ["BlackwingLair"] = {
        { BabbleBoss["Razorgore the Untamed"], "BWLRazorgore" },
        { BabbleBoss["Vaelastrasz the Corrupt"], "BWLVaelastrasz" },
        { BabbleBoss["Broodlord Lashlayer"], "BWLLashlayer" },
        { BabbleBoss["Firemaw"], "BWLFiremaw" },
        { BabbleBoss["Ebonroc"], "BWLEbonroc" },
        { BabbleBoss["Flamegor"], "BWLFlamegor" },
        { BabbleBoss["Chromaggus"], "BWLChromaggus" },
        { BabbleBoss["Nefarian"], "BWLNefarian" },
        { AL["Trash Mobs"], "BWLTrashMobs" },
    },
    ["Deadmines"] = {
        { BabbleBoss["Rhahk'Zor"], "VCRhahkZor" },
        { BabbleBoss["Miner Johnson"], "VCMinerJohnson" },
        { BabbleBoss["Sneed"], "VCSneedsShredder" },
        { BabbleBoss["Sneed's Shredder"], "VCSneed" },
        { BabbleBoss["Gilnid"], "VCGilnid" },
        { BabbleBoss["Captain Greenskin"], "VCCaptainGreenskin" },
        { BabbleBoss["Edwin VanCleef"], "VCVanCleef" },
        { BabbleBoss["Mr. Smite"], "VCMrSmite" },
        { BabbleBoss["Cookie"], "VCCookie" },
        { AL["Set: Defias Leather"], "DEADMINES" },
    },
    ["Gnomeregan"] = {
        { BabbleBoss["Viscous Fallout"], "GnViscousFallout" },
        { BabbleBoss["Grubbis"], "GnGrubbis" },
        { BabbleBoss["Electrocutioner 6000"], "GnElectrocutioner6000" },
        { BabbleBoss["Mekgineer Thermaplugg"], "GnMekgineerThermaplugg" },
        { BabbleBoss["Dark Iron Ambassador"], "GnDIAmbassador" },
        { BabbleBoss["Crowd Pummeler 9-60"], "GnCrowdPummeler960" },
        { AL["Trash Mobs"], "GnTrash" },
    },
    ["Karazhan"] = {
        { BabbleBoss["Attumen the Huntsman"], "KaraAttumen" },
        { AtlasLoot_TableNames["KaraNamed"][1], "KaraNamed" },
        { BabbleBoss["Moroes"], "KaraMoroes" },
        { BabbleBoss["Maiden of Virtue"], "KaraMaiden" },
        { AtlasLoot_TableNames["KaraOperaEvent"][1], "KaraOperaEvent" },
        { BabbleBoss["The Curator"], "KaraCurator" },
        { BabbleBoss["Terestian Illhoof"], "KaraIllhoof" },
        { BabbleBoss["Shade of Aran"], "KaraAran" },
        { BabbleBoss["Netherspite"], "KaraNetherspite" },
        { BabbleBoss["Nightbane"], "KaraNightbane" },
        { BabbleBoss["Chess Event"], "KaraChess" },
        { BabbleBoss["Prince Malchezaar"], "KaraPrince" },
        { AL["Trash Mobs"], "KaraTrash" },
    },
    ["MoltenCore"] = {
        { BabbleBoss["Lucifron"], "MCLucifron" },
        { BabbleBoss["Magmadar"], "MCMagmadar" },
        { BabbleBoss["Gehennas"], "MCGehennas" },
        { BabbleBoss["Garr"], "MCGarr" },
        { BabbleBoss["Shazzrah"], "MCShazzrah" },
        { BabbleBoss["Baron Geddon"], "MCGeddon" },
        { BabbleBoss["Golemagg the Incinerator"], "MCGolemagg" },
        { BabbleBoss["Sulfuron Harbinger"], "MCSulfuron" },
        { BabbleBoss["Majordomo Executus"], "MCMajordomo" },
        { BabbleBoss["Ragnaros"], "MCRagnaros" },
        { AL["Trash Mobs"], "MCTrashMobs" },
        { AL["Random Boss Loot"], "MCRANDOMBOSSDROPPS" },
    },
    ["Naxxramas"] = {
        { BabbleBoss["Patchwerk"], "NAXPatchwerk" },
        { BabbleBoss["Grobbulus"], "NAXGrobbulus" },
        { BabbleBoss["Gluth"], "NAXGluth" },
        { BabbleBoss["Thaddius"], "NAXThaddius" },
        { BabbleBoss["Anub'Rekhan"], "NAXAnubRekhan" },
        { BabbleBoss["Grand Widow Faerlina"], "NAXGrandWidowFaerlina" },
        { BabbleBoss["Maexxna"], "NAXMaexxna" },
        { BabbleBoss["Instructor Razuvious"], "NAXInstructorRazuvious" },
        { BabbleBoss["Gothik the Harvester"], "NAXGothikderHarvester" },
        { BabbleBoss["The Four Horsemen"], "NAXTheFourHorsemen" },
        { BabbleBoss["Noth the Plaguebringer"], "NAXNothderPlaguebringer" },
        { BabbleBoss["Heigan the Unclean"], "NAXHeiganderUnclean" },
        { BabbleBoss["Loatheb"], "NAXLoatheb" },
        { BabbleBoss["Sapphiron"], "NAXSapphiron" },
        { BabbleBoss["Kel'Thuzad"], "NAXKelThuzard" },
        { AL["Trash Mobs"], "NAXTrash" },
    },
    ["Scarlet Monastery"] = {
        { BabbleBoss["Houndmaster Loksey"], "SMHoundmasterLoksey" },
        { BabbleBoss["Arcanist Doan"], "SMDoan" },
        { BabbleBoss["Herod"], "SMHerod" },
        { BabbleBoss["High Inquisitor Fairbanks"], "SMFairbanks" },
        { BabbleBoss["Scarlet Commander Mograine"], "SMMograine" },
        { BabbleBoss["High Inquisitor Whitemane"], "SMWhitemane" },
        { BabbleBoss["Ironspine"], "SMIronspine" },
        { BabbleBoss["Azshir the Sleepless"], "SMAzshir" },
        { BabbleBoss["Fallen Champion"], "SMFallenChampion" },
        { BabbleBoss["Bloodmage Thalnos"], "SMBloodmageThalnos" },
        { AL["Trash Mobs"], "SMTrash" },
        { AL["Set: Chain of the Scarlet Crusade"], "SCARLET" },
    },
    ["Scholomance"] = {
        { AtlasLoot_TableNames["SCHOLOBloodStewardofKirtonos"][1], "SCHOLOBloodStewardofKirtonos" },
        { BabbleBoss["Kirtonos the Herald"], "SCHOLOKirtonostheHerald" },
        { BabbleBoss["Jandice Barov"], "SCHOLOJandiceBarov" },
        { BabbleBoss["Rattlegore"], "SCHOLORattlegore" },
        { AtlasLoot_TableNames["SCHOLODeathKnight"][1], "SCHOLODeathKnight" },
        { BabbleBoss["Marduk Blackpool"], "SCHOLOMarduk" },
        { BabbleBoss["Vectus"], "SCHOLOVectus" },
        { BabbleBoss["Ras Frostwhisper"], "SCHOLORasFrostwhisper" },
        { AL["Kormok"], "SCHOLOKormok" },
        { BabbleBoss["Instructor Malicia"], "SCHOLOInstructorMalicia" },
        { BabbleBoss["Doctor Theolen Krastinov"], "SCHOLODoctorTheolenKrastinov" },
        { BabbleBoss["Lorekeeper Polkelt"], "SCHOLOLorekeeperPolkelt" },
        { BabbleBoss["The Ravenian"], "SCHOLOTheRavenian" },
        { BabbleBoss["Lord Alexei Barov"], "SCHOLOLordAlexeiBarov" },
        { BabbleBoss["Lady Illucia Barov"], "SCHOLOLadyIlluciaBarov" },
        { BabbleBoss["Darkmaster Gandling"], "SCHOLODarkmasterGandling" },
        { AL["Trash Mobs"], "SCHOLOTrash" },
        { AL["Set: Necropile Raiment"], "ScholoCloth" },
        { AL["Set: Cadaverous Garb"], "ScholoLeather" },
        { AL["Set: Bloodmail Regalia"], "ScholoMail" },
        { AL["Set: Deathbone Guardian"], "ScholoPlate" },
    },
    ["ShadowfangKeep"] = {
        { BabbleBoss["Razorclaw the Butcher"], "BSFRazorclawtheButcher" },
        { BabbleBoss["Baron Silverlaine"], "BSFSilverlaine" },
        { BabbleBoss["Commander Springvale"], "BSFSpringvale" },
        { BabbleBoss["Odo the Blindwatcher"], "BSFOdotheBlindwatcher" },
        { BabbleBoss["Fenrus the Devourer"], "BSFFenrustheDevourer" },
        { BabbleBoss["Wolf Master Nandos"], "BSFWolfMasterNandos" },
        { BabbleBoss["Archmage Arugal"], "BSFArchmageArugal" },
        { AL["Trash Mobs"], "BSFTrash" },
    },
    ["TheStockade"] = {
        { BabbleBoss["Kam Deepfury"], "SWStKamDeepfury" },
        { BabbleBoss["Bruegal Ironknuckle"], "SWStBruegalIronknuckle" },
    },
    ["Stratholme"] = {
        { AtlasLoot_TableNames["STRATSkull"][1], "STRATSkull" },
        { AtlasLoot_TableNames["STRATStratholmeCourier"][1], "STRATStratholmeCourier" },
        { AtlasLoot_TableNames["STRATFrasSiabi"][1], "STRATFrasSiabi" },
        { AtlasLoot_TableNames["STRATAtiesh"][1], "STRATAtiesh" },
        { BabbleBoss["Hearthsinger Forresten"], "STRATHearthsingerForresten" },
        { AtlasLoot_TableNames["STRATTheUnforgiven"][1], "STRATTheUnforgiven" },
        { BabbleBoss["Timmy the Cruel"], "STRATTimmytheCruel" },
        { AtlasLoot_TableNames["STRATMalorsStrongbox"][1], "STRATMalorsStrongbox" },
        { AtlasLoot_TableNames["STRATCrimsonHammersmith"][1], "STRATCrimsonHammersmith" },
        { AtlasLoot_TableNames["STRATBSPlansSerenity"][1], "STRATBSPlansSerenity" },
        { BabbleBoss["Cannon Master Willey"], "STRATCannonMasterWilley" },
        { BabbleBoss["Archivist Galford"], "STRATArchivistGalford" },
        { BabbleBoss["Balnazzar"], "STRATBalnazzar" },
        { AL["Sothos and Jarien"], "STRATSothosJarien" },
        { AtlasLoot_TableNames["STRATStonespine"][1], "STRATStonespine" },
        { BabbleBoss["Baroness Anastari"], "STRATBaronessAnastari" },
        { AtlasLoot_TableNames["STRATBlackGuardSwordsmith"][1], "STRATBlackGuardSwordsmith" },
        { AtlasLoot_TableNames["STRATBSPlansCorruption"][1], "STRATBSPlansCorruption" },
        { BabbleBoss["Nerub'enkan"], "STRATNerubenkan" },
        { BabbleBoss["Maleki the Pallid"], "STRATMalekithePallid" },
        { BabbleBoss["Magistrate Barthilas"], "STRATMagistrateBarthilas" },
        { BabbleBoss["Ramstein the Gorger"], "STRATRamsteintheGorger" },
        { BabbleBoss["Baron Rivendare"], "STRATBaronRivendare" },
        { AL["Trash Mobs"], "STRATTrash" },
        { AL["Set: The Postmaster"], "STRAT" },
    },
    ["SunkenTemple"] = {
        { AtlasLoot_TableNames["STSpawnOfHakkar"][1], "STSpawnOfHakkar" },
        { AtlasLoot_TableNames["STTrollMinibosses"][1], "STTrollMinibosses" },
        { BabbleBoss["Atal'alarion"], "STAtalalarion" },
        { BabbleBoss["Dreamscythe"], "STDreamscythe" },
        { BabbleBoss["Weaver"], "STWeaver"},
        { BabbleBoss["Avatar of Hakkar"], "STAvatarofHakkar" },
        { BabbleBoss["Jammal'an the Prophet"], "STJammalan" },
        { BabbleBoss["Ogom the Wretched"], "STOgom" },
        { BabbleBoss["Morphaz"], "STMorphaz" },
        { BabbleBoss["Hazzas"], "STHazzas" },
        { BabbleBoss["Shade of Eranikus"], "STEranikus" },
        { AL["Trash Mobs"], "STTrash" },
    },
    ["Uldaman"] = {
        { BabbleBoss["Revelosh"], "UldRevelosh" },
        { BabbleBoss["Ironaya"], "UldIronaya" },
        { BabbleBoss["Ancient Stone Keeper"], "UldAncientStoneKeeper" },
        { BabbleBoss["Galgann Firehammer"], "UldGalgannFirehammer" },
        { BabbleBoss["Grimlok"], "UldGrimlok" },
        { BabbleBoss["Archaedas"], "UldArchaedas" },
        { AL["Trash Mobs"], "UldTrash" },
    },
    ["ZulGurub"] = {
        { BabbleBoss["High Priestess Jeklik"], "ZGJeklik" },
        { BabbleBoss["High Priest Venoxis"], "ZGVenoxis" },
        { BabbleBoss["High Priestess Mar'li"], "ZGMarli" },
        { BabbleBoss["Bloodlord Mandokir"], "ZGMandokir" },
        { BabbleBoss["Gri'lek"], "ZGGrilek" },
        { BabbleBoss["Hazza'rah"], "ZGHazzarah" },
        { BabbleBoss["Renataki"], "ZGRenataki" },
        { BabbleBoss["Wushoolay"], "ZGWushoolay" },
        { BabbleBoss["Gahz'ranka"], "ZGGahzranka" },
        { BabbleBoss["High Priest Thekal"], "ZGThekal" },
        { BabbleBoss["High Priestess Arlokk"], "ZGArlokk" },
        { BabbleBoss["Jin'do the Hexxer"], "ZGJindo" },
        { BabbleBoss["Hakkar"], "ZGHakkar" },
        { AL["Random Boss Loot"], "ZGShared" },
        { AL["Trash Mobs"], "ZGTrash1" },
        { AL["ZG Enchants"], "ZGEnchants" },
    },
    ["BlackfathomDeeps"] = {
        { BabbleBoss["Ghamoo-ra"], "BFDGhamoora" },
        { AL["Lorgalis Manuscript"], "BFDQuestItems" },
        { BabbleBoss["Lady Sarevess"], "BFDLadySarevess" },
        { BabbleBoss["Gelihast"], "BFDGelihast" },
        { BabbleBoss["Baron Aquanis"], "BFDBaronAquanis" },
        { AL["Fathom Core"], "BFDQuestItems" },
        { BabbleBoss["Twilight Lord Kelris"], "BFDTwilightLordKelris" },
        { AtlasLoot_TableNames["BFDOldSerrakis"][1], "BFDOldSerrakis" },
        { BabbleBoss["Aku'mai"], "BFDAkumai" },
        { AL["Trash Mobs"], "BFDTrash" },
    },
    ["CoTOldHillsbrad"] = {
        { BabbleBoss["Lieutenant Drake"], "CoTHillsbradDrake" },
        { BabbleBoss["Captain Skarloc"], "CoTHillsbradSkarloc" },
        { BabbleBoss["Epoch Hunter"], "CoTHillsbradHunter" },
        { AL["Trash Mobs"], "CoTHillsbradTrash" },
    },
    ["CoTBlackMorass"] = {
        { BabbleBoss["Chrono Lord Deja"], "CoTMorassDeja" },
        { BabbleBoss["Temporus"], "CoTMorassTemporus" },
        { BabbleBoss["Aeonus"], "CoTMorassAeonus" },
        { AL["Trash Mobs"], "CoTMorassTrash" },
    },
    ["CoTHyjal"] = {
        { BabbleBoss["Rage Winterchill"], "MountHyjalWinterchill" },
        { BabbleBoss["Anetheron"], "MountHyjalAnetheron" },
        { BabbleBoss["Kaz'rogal"], "MountHyjalKazrogal" },
        { BabbleBoss["Azgalor"], "MountHyjalAzgalor" },
        { BabbleBoss["Archimonde"], "MountHyjalArchimonde" },
    },
    ["DireMaulEast"] = {
        { BabbleBoss["Pusillin"], "DMEPusillin" },
        { BabbleBoss["Zevrim Thornhoof"], "DMEZevrimThornhoof" },
        { BabbleBoss["Hydrospawn"], "DMEHydro" },
        { BabbleBoss["Lethtendris"], "DMELethtendris" },
        { BabbleBoss["Pimgib"], "DMEPimgib" },
        { BabbleBoss["Alzzin the Wildshaper"], "DMEAlzzin" },
        { AL["Isalien"], "DMEIsalien" },
        { AL["Trash Mobs"], "DMETrash" },
        { AL["Dire Maul Books"], "DMBooks" },
    },
    ["DireMaulWest"] = {
        { BabbleBoss["Tendris Warpwood"], "DMWTendrisWarpwood" },
        { BabbleBoss["Illyanna Ravenoak"], "DMWIllyannaRavenoak" },
        { BabbleBoss["Magister Kalendris"], "DMWMagisterKalendris" },
        { BabbleBoss["Tsu'zee"], "DMWTsuzee" },
        { BabbleBoss["Immol'thar"], "DMWImmolthar" },
        { BabbleBoss["Lord Hel'nurath"], "DMWHelnurath" },
        { BabbleBoss["Prince Tortheldrin"], "DMWPrinceTortheldrin" },
        { AL["Trash Mobs"], "DMWTrash" },
        { AL["Dire Maul Books"], "DMBooks" }, 
    },
    ["DireMaulNorth"] = {
        { BabbleBoss["Guard Mol'dar"], "DMNGuardMoldar" },
        { BabbleBoss["Stomper Kreeg"], "DMNStomperKreeg" },
        { BabbleBoss["Guard Fengus"], "DMNGuardFengus" },
        { "Knot Thimblejack", "DMNThimblejack" },
        { BabbleBoss["Guard Slip'kik"], "DMNGuardSlipkik" },
        { BabbleBoss["Captain Kromcrush"], "DMNCaptainKromcrush" },
        { BabbleBoss["King Gordok"], "DMNKingGordok" },
        { BabbleBoss["Cho'Rush the Observer"], "DMNChoRush" },
        { AL["Tribute Run"], "DMNTRIBUTERUN" },
        { AL["Dire Maul Books"], "DMBooks" },
    },
    ["Maraudon"] = {
        { BabbleBoss["Noxxion"], "MaraNoxxion" },
        { BabbleBoss["Razorlash"], "MaraRazorlash" },
        { BabbleBoss["Lord Vyletongue"], "MaraLordVyletongue" },
        { BabbleBoss["Meshlok the Harvester"], "MaraMeshlok" },
        { BabbleBoss["Celebras the Cursed"], "MaraCelebras" },
        { BabbleBoss["Landslide"], "MaraLandslide" },
        { BabbleBoss["Tinkerer Gizlock"], "MaraTinkererGizlock" },
        { BabbleBoss["Rotgrip"], "MaraRotgrip" },
        { BabbleBoss["Princess Theradras"], "MaraPrincessTheradras" },
    },
    ["Onyxia"] = {
         { BabbleBoss["Onyxia"], "Onyxia" },
    },
    ["RagefireChasm"] = {
        { BabbleBoss["Taragaman the Hungerer"], "RFCTaragaman" },
        { BabbleBoss["Jergosh the Invoker"], "RFCJergosh" },
    },
    ["RazorfenDowns"] = {
        { BabbleBoss["Tuten'kash"], "RFDTutenkash" },
        { BabbleBoss["Mordresh Fire Eye"], "RFDMordreshFireEye" },
        { BabbleBoss["Glutton"], "RFDGlutton" },
        { BabbleBoss["Ragglesnout"], "RFDRagglesnout" },
        { BabbleBoss["Amnennar the Coldbringer"], "RFDAmnennar" },
        { AL["Trash Mobs"], "RFDTrash" },
    },
    ["RazorfenKraul"] = {
        { BabbleBoss["Death Speaker Jargba"], "RFKDeathSpeakerJargba" },
        { BabbleBoss["Overlord Ramtusk"], "RFKOverlordRamtusk" },
        { BabbleBoss["Agathelos the Raging"], "RFKAgathelos" },
        { BabbleBoss["Blind Hunter"], "RFKBlindHunter" },
        { BabbleBoss["Charlga Razorflank"], "RFKCharlgaRazorflank" },
        { BabbleBoss["Earthcaller Halmgar"], "RFKEarthcallerHalmgar" },
        { AL["Trash Mobs"], "RFKTrash" },
    },
    ["RuinsofAQ"] = {
        { BabbleBoss["Kurinnaxx"], "AQ20Kurinnaxx" },
        { BabbleBoss["Lieutenant General Andorov"], "AQ20Andorov" },
        { AtlasLoot_TableNames["AQ20CAPTIAN"][1], "AQ20CAPTIAN" },
        { BabbleBoss["General Rajaxx"], "AQ20Rajaxx" },
        { BabbleBoss["Moam"], "AQ20Moam" },
        { BabbleBoss["Buru the Gorger"], "AQ20Buru" },
        { BabbleBoss["Ayamiss the Hunter"], "AQ20Ayamiss" },
        { BabbleBoss["Ossirian the Unscarred"], "AQ20Ossirian" },
        { AL["Trash Mobs"], "AQ20Trash" },
        { AL["Class Books"], "AQ20ClassBooks" },
        { AL["AQ Enchants"], "AQEnchants" },
    },
    ["TempleofAQ"] = {
        { BabbleBoss["The Prophet Skeram"], "AQ40Skeram" },
        { BabbleBoss["The Bug Family"], "AQ40Vem" },
        { BabbleBoss["Battleguard Sartura"], "AQ40Sartura" },
        { BabbleBoss["Fankriss the Unyielding"], "AQ40Fankriss" },
        { BabbleBoss["Viscidus"], "AQ40Viscidus" },
        { BabbleBoss["Princess Huhuran"], "AQ40Huhuran" },
        { BabbleBoss["The Twin Emperors"], "AQ40Emperors" },
        { BabbleBoss["Ouro"], "AQ40Ouro" },
        { BabbleBoss["C'Thun"], "AQ40CThun" },
        { AL["Trash Mobs"], "AQ40Trash1" },
        { AL["AQ Enchants"], "AQEnchants" },
        { AL["AQ Opening Quest Chain"], "AQOpening" },
    },
    ["WailingCaverns"] = {
        { BabbleBoss["Lord Cobrahn"], "WCLordCobrahn" },
        { BabbleBoss["Lady Anacondra"], "WCLadyAnacondra" },
        { BabbleBoss["Kresh"], "WCKresh" },
        { BabbleBoss["Lord Pythas"], "WCLordPythas" },
        { BabbleBoss["Skum"], "WCSkum" },
        { BabbleBoss["Lord Serpentis"], "WCLordSerpentis" },
        { BabbleBoss["Verdan the Everliving"], "WCVerdan" },
        { BabbleBoss["Mutanus the Devourer"], "WCMutanus" },
        { BabbleBoss["Deviate Faerie Dragon"], "WCDeviateFaerieDragon" },
        { AL["Set: Embrace of the Viper"], "WAILING" },
    },
    ["ZulFarrak"] = {
        { BabbleBoss["Antu'sul"], "ZFAntusul" },
        { BabbleBoss["Theka the Martyr"], "ZFThekatheMartyr" },
        { BabbleBoss["Witch Doctor Zum'rah"], "ZFWitchDoctorZumrah" },
        { BabbleBoss["Nekrum Gutchewer"], "ZFNekrumGutchewer" },
        { AtlasLoot_TableNames["ZFSezzziz"][1], "ZFSezzziz" },
        { AtlasLoot_TableNames["ZFDustwraith"][1], "ZFDustwraith" },
        { BabbleBoss["Sergeant Bly"], "ZFSergeantBly" },
        { BabbleBoss["Sandfury Executioner"], "ZFSandfury" },
        { BabbleBoss["Hydromancer Velratha"], "ZFHydromancerVelratha" },
        { BabbleBoss["Gahz'rilla"], "ZFGahzrilla" },
        { BabbleBoss["Chief Ukorz Sandscalp"], "ZFChiefUkorzSandscalp" },
        { BabbleBoss["Zerillis"], "ZFZerillis" },
        { AL["Trash Mobs"], "ZFTrash" },
    },
    ["AuchManaTombs"] = {
        { BabbleBoss["Pandemonius"], "AuchManaPandemonius" },
        { BabbleBoss["Tavarok"], "AuchManaTavarok" },
        { BabbleBoss["Nexus-Prince Shaffar"], "AuchManaNexusPrince" },
        { AL["Yor"], "AuchManaYor" },
        { AL["Trash Mobs"], "AuchManaTrash" },
    },
    ["AuchCrypts"] = {
        { BabbleBoss["Shirrak the Dead Watcher"], "AuchCryptsShirrak" },
        { BabbleBoss["Exarch Maladaar"], "AuchCryptsExarch" },
        { AL["Avatar of the Martyred"], "AuchCryptsAvatar" },
        { AL["Trash Mobs"], "AuchCryptsTrash" }, 
    },
    ["AuchSethekk"] = {
        { BabbleBoss["Darkweaver Syth"], "AuchSethekkDarkweaver" },
        { BabbleBoss["Talon King Ikiss"], "AuchSethekkTalonKing" },
        { AtlasLoot_TableNames["AuchSethekkRavenGod"][1], "AuchSethekkRavenGod" },
        { AL["Trash Mobs"], "AuchSethekkTrash" },
    },
    ["AuchShadowLab"] = {
        { BabbleBoss["Ambassador Hellmaw"], "AuchShadowHellmaw" },
        { BabbleBoss["Blackheart the Inciter"], "AuchShadowBlackheart" },
        { BabbleBoss["Grandmaster Vorpil"], "AuchShadowGrandmaster" },
        { BabbleBoss["Murmur"], "AuchShadowMurmur" },
        { AL["Trash Mobs"], "AuchShadowTrash" },
    },
    ["BlackTemple"] = {
        { BabbleBoss["High Warlord Naj'entus"], "BTNajentus" },
        { BabbleBoss["Supremus"], "BTSupremus" },
        { BabbleBoss["Teron Gorefiend"], "BTGorefiend" },
        { BabbleBoss["Gurtogg Bloodboil"], "BTBloodboil" },
        { AL["Shade of Akama"], "BTAkama" },
        { AL["Essence of Souls"], "BTEssencofSouls" },
        { BabbleBoss["Mother Shahraz"], "BTShahraz" },
        { AL["Illidari Council"], "BTCouncil" },
        { BabbleBoss["Illidan Stormrage"], "BTIllidanStormrage" },
        { AL["Trash Mobs"], "BTTrash" },
    },
    ["CFRSlavePens"] = {
        { BabbleBoss["Mennu the Betrayer"], "CFRSlaveMennu" },
        { BabbleBoss["Rokmar the Crackler"], "CFRSlaveRokmar" },
        { BabbleBoss["Quagmirran"], "CFRSlaveQuagmirran" },
    },
    ["CFRUnderbog"] = {
        { BabbleBoss["Hungarfen"], "CFRUnderHungarfen" },
        { BabbleBoss["Ghaz'an"], "CFRUnderGhazan" },
        { BabbleBoss["Swamplord Musel'ek"], "CFRUnderSwamplord" },
        { BabbleBoss["The Black Stalker"], "CFRUnderStalker" },
    },
    ["CFRSteamvault"] = {
        { BabbleBoss["Hydromancer Thespia"], "CFRSteamThespia" },
        { BabbleBoss["Mekgineer Steamrigger"], "CFRSteamSteamrigger" },
        { BabbleBoss["Warlord Kalithresh"], "CFRSteamWarlord" },
        { AL["Trash Mobs"], "CFRSteamTrash" },
    },
    ["CFRSerpentshrine"] = {
        { BabbleBoss["Hydross the Unstable"], "CFRSerpentHydross" },
        { BabbleBoss["Leotheras the Blind"], "CFRSerpentLeotheras" },
        { BabbleBoss["Fathom-Lord Karathress"], "CFRSerpentKarathress" },
        { BabbleBoss["Morogrim Tidewalker"], "CFRSerpentMorogrim" },
        { BabbleBoss["The Lurker Below"], "CFRSerpentLurker" },
        { BabbleBoss["Lady Vashj"], "CFRSerpentVashj" },
        { AL["Trash Mobs"], "CFRSerpentTrash" },
    },
    ["Gruul"] = {
        { BabbleBoss["High King Maulgar"], "GruulsLairHighKingMaulgar" },
        { BabbleBoss["Gruul the Dragonkiller"], "GruulGruul" },
    },
    ["HCRamparts"] = {
        { BabbleBoss["Watchkeeper Gargolmar"], "HCRampWatchkeeper" },
        { BabbleBoss["Omor the Unscarred"], "HCRampOmor" },
        { BabbleBoss["Vazruden the Herald"], "HCRampVazruden" },
        { BabbleBoss["Nazan"], "HCRampNazan" },
        { AtlasLoot_TableNames["HCRampFelIronChest"][1], "HCRampFelIronChest" },
    },
    ["HCFurnace"] = {
        { BabbleBoss["The Maker"], "HCFurnaceMaker" },
        { BabbleBoss["Broggok"], "HCFurnaceBroggok" },
        { BabbleBoss["Keli'dan the Breaker"], "HCFurnaceBreaker" },
    },
    ["HCShatteredHalls"] = {
        { BabbleBoss["Grand Warlock Nethekurse"], "HCHallsNethekurse" },
        { BabbleBoss["Blood Guard Porung"], "HCHallsPorung" },
        { BabbleBoss["Warbringer O'mrogg"], "HCHallsOmrogg" },
        { BabbleBoss["Warchief Kargath Bladefist"], "HCHallsKargath" },
        { AL["Trash Mobs"], "HCHallsTrash" },
    },
    ["HCMagLair"] = {
        { BabbleBoss["Magtheridon"], "HCMagtheridon" },
    },
    ["TKMech"] = {
        { BabbleBoss["Gatewatcher Gyro-Kill"], "TKMechGyro" },
        { BabbleBoss["Gatewatcher Iron-Hand"], "TKMechIron" },
        { AtlasLoot_TableNames["TKMechCacheoftheLegion"][1], "TKMechCacheoftheLegion" },
        { BabbleBoss["Mechano-Lord Capacitus"], "TKMechCapacitus" },
        { BabbleBoss["Nethermancer Sepethrea"], "TKMechSepethrea" },
        { BabbleBoss["Pathaleon the Calculator"], "TKMechCalc" },
        { AL["Trash Mobs"], "TKMechTrash" },
    },
    ["TKBot"] = {
        { BabbleBoss["Commander Sarannis"], "TKBotSarannis" },
        { BabbleBoss["High Botanist Freywinn"], "TKBotFreywinn" },
        { BabbleBoss["Thorngrin the Tender"], "TKBotThorngrin" },
        { BabbleBoss["Laj"], "TKBotLaj" },
        { BabbleBoss["Warp Splinter"], "TKBotSplinter" },
        { AL["Trash Mobs"], "TKBotTrash" },
    },
    ["TKArc"] = {
        { BabbleBoss["Zereketh the Unbound"], "TKArcUnbound" },
        { BabbleBoss["Wrath-Scryer Soccothrates"], "TKArcScryer" },
        { BabbleBoss["Dalliah the Doomsayer"], "TKArcDalliah" },
        { BabbleBoss["Harbinger Skyriss"], "TKArcHarbinger" },
        { AL["Trash Mobs"], "TKArcTrash" },
    },
    ["TKEye"] = {
        { BabbleBoss["Al'ar"], "TKEyeAlar" },
        { BabbleBoss["High Astromancer Solarian"], "TKEyeSolarian" },
        { BabbleBoss["Void Reaver"], "TKEyeVoidReaver" },
        { BabbleBoss["Kael'thas Sunstrider"], "TKEyeKaelthas" },
        { AL["Legendary Items for Kael'thas Fight"], "TKEyeLegendaries" },
        { AL["Trash Mobs"], "TKEyeTrash" },
    },
    ["WorldBosses"] = {
        { BabbleBoss["Azuregos"], "AAzuregos" },
        { BabbleBoss["Doom Lord Kazzak"], "DoomLordKazzak"},
        { BabbleBoss["Doomwalker"], "DDoomwalker" },
        { BabbleBoss["Emeriss"], "DEmeriss" },
        { AL["Highlord Kruul"], "KKruul" },
        { BabbleBoss["Lethon"], "DLethon"},
        { BabbleBoss["Taerar"], "DTaerar" },
        { BabbleBoss["Ysondre"], "DYsondre" },
    },
	["WorldEvents"] = {
        { AL["Children's Week"], "ChildrensWeek" },
		{ AL["Elemental Invasion"], "ElementalInvasion" },
        { AL["Gurubashi Arena"], "GurubashiArena"},
        { AL["Stranglethorn Fishing Extravaganza"], "FishingExtravaganza" },
    },
    ["Factions"] = {
        { BabbleFaction["The Aldor"], "Aldor1" },
        { BabbleFaction["Argent Dawn"], "Argent1" },
        { BabbleFaction["Ashtongue Deathsworn"], "Ashtongue1" },
        { BabbleFaction["Bloodsail Buccaneers"], "Bloodsail1" },
        { BabbleFaction["Brood of Nozdormu"], "AQBroodRings" },
        { BabbleFaction["Cenarion Circle"], "Cenarion1" },
        { BabbleFaction["Cenarion Expedition"], "CExpedition1" },
        { BabbleFaction["The Consortium"], "Consortium1" },
        { BabbleFaction["Darkmoon Faire"], "Darkmoon1" },
        { BabbleFaction["Frostwolf Clan"], "Frostwolf1" },
        { BabbleFaction["Gelkis Clan Centaur"], "GelkisClan1" },
        { BabbleFaction["Hydraxian Waterlords"], "WaterLords1" },
        { BabbleFaction["Honor Hold"], "HonorHold1" },
        { BabbleFaction["Keepers of Time"], "KeepersofTime1" },
        { BabbleFaction["Kurenai"], "Kurenai1" },
        { BabbleFaction["Lower City"], "LowerCity1" },
        { BabbleFaction["The Mag'har"], "Maghar1" },
        { BabbleFaction["Magram Clan Centaur"], "MagramClan1" },
        { BabbleFaction["Netherwing"], "Netherwing1" },
        { BabbleFaction["Ogri'la"], "Ogrila1" },
        { BabbleFaction["The Scale of the Sands"], "ScaleSands1" },
        { BabbleFaction["The Scryers"], "Scryer1" },
        { BabbleFaction["The Sha'tar"], "Shatar1" },
        { BabbleFaction["Sha'tari Skyguard"], "Skyguard1" },
        { BabbleFaction["Sporeggar"], "Sporeggar1" },
        { BabbleFaction["Stormpike Guard"], "Stormpike1" },
        { BabbleFaction["Thorium Brotherhood"], "Thorium1" },
        { BabbleFaction["Thrallmar"], "Thrallmar1" },
        { BabbleFaction["Timbermaw Hold"], "Timbermaw" },
        { BabbleFaction["Tranquillien"], "Tranquillien1" },
        { BabbleFaction["The Violet Eye"], "VioletEye1" },
        { BabbleFaction["Wintersaber Trainers"], "Wintersaber1" },
        { BabbleFaction["Zandalar Tribe"], "Zandalar1" },
    },
    ["ArenaPvPArmor"] = {
        { BabbleClass["Druid"], "ArenaDruid" },
        { BabbleClass["Hunter"], "ArenaHunter" },
        { BabbleClass["Mage"], "ArenaMage" },
        { BabbleClass["Paladin"], "ArenaPaladin" },
        { BabbleClass["Priest"], "ArenaPriest" },
        { BabbleClass["Rogue"], "ArenaRogue" },
        { BabbleClass["Shaman"], "ArenaShaman" },
        { BabbleClass["Warlock"], "ArenaWarlock" },
        { BabbleClass["Warrior"], "ArenaWarrior" },
    },
    ["Arena2PvPArmor"] = {
        { BabbleClass["Druid"], "Arena2Druid" },
        { BabbleClass["Hunter"], "Arena2Hunter" },
        { BabbleClass["Mage"], "Arena2Mage" },
        { BabbleClass["Paladin"], "Arena2Paladin" },
        { BabbleClass["Priest"], "Arena2Priest" },
        { BabbleClass["Rogue"], "Arena2Rogue" },
        { BabbleClass["Shaman"], "Arena2Shaman" },
        { BabbleClass["Warlock"], "Arena2Warlock" },
        { BabbleClass["Warrior"], "Arena2Warrior" },
    },
    ["CraftSetBlacksmith"] = {
        { AL["Imperial Plate"], "ImperialPlate" },
        { AL["The Darksoul"], "TheDarksoul" },
        { AL["Fel Iron Plate"], "FelIronPlate" },
        { AL["Adamantite Battlegear"], "AdamantiteB" },
        { AL["Flame Guard"], "FlameG" },
        { AL["Enchanted Adamantite Armor"], "EnchantedAdaman" },
        { AL["Khorium Ward"], "KhoriumWard" },
        { AL["Faith in Felsteel"], "FaithFelsteel" },
        { AL["Burning Rage"], "BurningRage" },
        { AL["Bloodsoul Embrace"], "BloodsoulEmbrace" },
        { AL["Fel Iron Chain"], "FelIronChain" },
    },
    ["CraftSetLeatherwork"] = {
        { AL["Volcanic Armor"], "VolcanicArmor" },
        { AL["Ironfeather Armor"], "IronfeatherArmor" },
        { AL["Stormshroud Armor"], "StormshroudArmor" },
        { AL["Devilsaur Armor"], "DevilsaurArmor" },
        { AL["Blood Tiger Harness"], "BloodTigerH" },
        { AL["Primal Batskin"], "PrimalBatskin" },
        { AL["Wild Draenish Armor"], "WildDraenishA" },
        { AL["Thick Draenic Armor"], "ThickDraenicA" },
        { AL["Fel Skin"], "FelSkin" },
        { AL["Strength of the Clefthoof"], "SClefthoof" },
        { AL["Primal Intent"], "PrimalIntent" },
        { AL["Windhawk Armor"], "WindhawkArmor" },   
        { AL["Green Dragon Mail"], "GreenDragonM" },
        { AL["Blue Dragon Mail"], "BlueDragonM" },
        { AL["Black Dragon Mail"], "BlackDragonM" },
        { AL["Scaled Draenic Armor"], "ScaledDraenicA" },
        { AL["Felscale Armor"], "FelscaleArmor" },
        { AL["Felstalker Armor"], "FelstalkerArmor" },
        { AL["Fury of the Nether"], "NetherFury" },
        { AL["Netherscale Armor"], "NetherscaleArmor" },
        { AL["Netherstrike Armor"], "NetherstrikeArmor" },
    },
    ["CraftSetTailor"] = {
        { AL["Bloodvine Garb"], "BloodvineG" },
        { AL["Netherweave Vestments"], "NeatherVest" },
        { AL["Imbued Netherweave"], "ImbuedNeather" },
        { AL["Arcanoweave Vestments"], "ArcanoVest" },
        { AL["The Unyielding"], "TheUnyielding" },
        { AL["Whitemend Wisdom"], "WhitemendWis" },
        { AL["Spellstrike Infusion"], "SpellstrikeInfu" },
        { AL["Battlecast Garb"], "BattlecastG" },
        { AL["Soulcloth Embrace"], "SoulclothEm" },
        { AL["Primal Mooncloth"], "PrimalMoon" },
        { AL["Shadow's Embrace"], "ShadowEmbrace" },
        { AL["Wrath of Spellfire"], "SpellfireWrath" },
    },
    ["DungeonSets12"] = {
        { BabbleClass["Druid"], "T0Druid" },
        { BabbleClass["Hunter"], "T0Hunter" },
        { BabbleClass["Mage"], "T0Mage" },
        { BabbleClass["Paladin"], "T0Paladin" },
        { BabbleClass["Priest"], "T0Priest" },
        { BabbleClass["Rogue"], "T0Rogue" },
        { BabbleClass["Shaman"], "T0Shaman" },
        { BabbleClass["Warlock"], "T0Warlock" },
        { BabbleClass["Warrior"], "T0Warrior" },
    },
    ["DungeonSets3"] = {
        { AtlasLoot_TableNames["DS3Hallowed"][1], "DS3Hallowed" },
        { AtlasLoot_TableNames["DS3Incanter"][1], "DS3Incanter" },
        { AtlasLoot_TableNames["DS3Mana"][1], "DS3Mana" },
        { AtlasLoot_TableNames["DS3Oblivion"][1], "DS3Oblivion" },
        { AtlasLoot_TableNames["DS3Assassin"][1], "DS3Assassin" },
        { AtlasLoot_TableNames["DS3Moonglade"][1], "DS3Moonglade" },
        { AtlasLoot_TableNames["DS3Wastewalker"][1], "DS3Wastewalker" },
        { AtlasLoot_TableNames["DS3Beast"][1], "DS3Beast" },
        { AtlasLoot_TableNames["DS3Desolation"][1], "DS3Desolation" },
        { AtlasLoot_TableNames["DS3Tidefury"][1], "DS3Tidefury" },
        { AtlasLoot_TableNames["DS3Bold"][1], "DS3Bold" },
        { AtlasLoot_TableNames["DS3Doom"][1], "DS3Doom" },
        { AtlasLoot_TableNames["DS3Right"][1], "DS3Right" },
    },
    ["Pre60Sets"] = {
        { AL["Bloodmail Regalia"], "ScholoMail" },
        { AL["Cadaverous Garb"], "ScholoLeather" },
        { AL["Chain of the Scarlet Crusade"], "SCARLET" },
        { AL["Dal'Rend's Arms"], "DalRend" },
        { AL["Deathbone Guardian"], "ScholoPlate" },
        { AL["Defias Leather"], "DEADMINES" },
        { AL["Embrace of the Viper"], "WAILING" },
        { AL["Ironweave Battlesuit"], "IRONWEAVE" },
        { AL["Necropile Raiment"], "ScholoCloth" },
        { AL["Primal Blessing"], "PrimalBlessing" },
        { AL["Scourge Invasion"], "ScourgeInvasion" },
        { AL["Shard of the Gods"], "ShardOfGods" },
        { AL["Spider's Kiss"], "SpiderKiss" },
        { AL["Spirit of Eskhandar"], "SpiritofEskhandar" },
        { AL["The Gladiator"], "BLACKROCKD" },
        { AL["The Postmaster"], "STRAT" },
        { AL["The Twin Blades of Hakkari"], "HakkariBlades" },
        { AL["Zul'Gurub Rings"], "ZGRings" },
        { AL["The Twin Stars"], "TwinStars" },
        { AL["The Twin Blades of Azzinoth"], "AzzinothBlades" },
    },
    ["Lvl60PvPArmor"] = {
        { BabbleClass["Druid"], "PVPDruid" },
        { BabbleClass["Hunter"], "PVPHunter" },
        { BabbleClass["Mage"], "PVPMage" },
        { BabbleClass["Paladin"], "PVPPaladin" },
        { BabbleClass["Priest"], "PVPPriest" },
        { BabbleClass["Rogue"], "PVPRogue" },
        { BabbleClass["Shaman"], "PVPShaman" },
        { BabbleClass["Warlock"], "PVPWarlock" },
        { BabbleClass["Warrior"], "PVPWarrior" },
    },
    ["Lvl70PvPArmor"] = {
        { BabbleClass["Druid"], "PVP70Druid1" },
        { BabbleClass["Hunter"], "PVP70Hunter" },
        { BabbleClass["Mage"], "PVP70Mage" },
        { BabbleClass["Paladin"], "PVP70Paladin1" },
        { BabbleClass["Priest"], "PVP70Priest" },
        { BabbleClass["Rogue"], "PVP70Rogue" },
        { BabbleClass["Shaman"], "PVP70Shaman1" },
        { BabbleClass["Warlock"], "PVP70Warlock" },
        { BabbleClass["Warrior"], "PVP70Warrior" },
    },
    ["RuinsofAQSets"] = {
        { BabbleClass["Druid"], "AQ20Druid" },
        { BabbleClass["Hunter"], "AQ20Hunter" },
        { BabbleClass["Mage"], "AQ20Mage" },
        { BabbleClass["Paladin"], "AQ20Paladin" },
        { BabbleClass["Priest"], "AQ20Priest" },
        { BabbleClass["Rogue"], "AQ20Rogue" },
        { BabbleClass["Shaman"], "AQ20Shaman" },
        { BabbleClass["Warlock"], "AQ20Warlock" },
        { BabbleClass["Warrior"], "AQ20Warrior" },
    },
    ["TempleofAQSets"] = {
        { BabbleClass["Druid"], "AQ40Druid" },
        { BabbleClass["Hunter"], "AQ40Hunter" },
        { BabbleClass["Mage"], "AQ40Mage" },
        { BabbleClass["Paladin"], "AQ40Paladin" },
        { BabbleClass["Priest"], "AQ40Priest" },
        { BabbleClass["Rogue"], "AQ40Rogue" },
        { BabbleClass["Shaman"], "AQ40Shaman" },
        { BabbleClass["Warlock"], "AQ40Warlock" },
        { BabbleClass["Warrior"], "AQ40Warrior" },
    },
    ["T1Sets"] = {
        { BabbleClass["Druid"], "T1Druid" },
        { BabbleClass["Hunter"], "T1Hunter" },
        { BabbleClass["Mage"], "T1Mage" },
        { BabbleClass["Paladin"], "T1Paladin" },
        { BabbleClass["Priest"], "T1Priest" },
        { BabbleClass["Rogue"], "T1Rogue" },
        { BabbleClass["Shaman"], "T1Shaman" },
        { BabbleClass["Warlock"], "T1Warlock" },
        { BabbleClass["Warrior"], "T1Warrior" },
    },
    ["T2Sets"] = {
        { BabbleClass["Druid"], "T2Druid" },
        { BabbleClass["Hunter"], "T2Hunter" },
        { BabbleClass["Mage"], "T2Mage" },
        { BabbleClass["Paladin"], "T2Paladin" },
        { BabbleClass["Priest"], "T2Priest" },
        { BabbleClass["Rogue"], "T2Rogue" },
        { BabbleClass["Shaman"], "T2Shaman" },
        { BabbleClass["Warlock"], "T2Warlock" },
        { BabbleClass["Warrior"], "T2Warrior" },
    },
    ["T3Sets"] = {
        { BabbleClass["Druid"], "T3Druid" },
        { BabbleClass["Hunter"], "T3Hunter" },
        { BabbleClass["Mage"], "T3Mage" },
        { BabbleClass["Paladin"], "T3Paladin" },
        { BabbleClass["Priest"], "T3Priest" },
        { BabbleClass["Rogue"], "T3Rogue" },
        { BabbleClass["Shaman"], "T3Shaman" },
        { BabbleClass["Warlock"], "T3Warlock" },
        { BabbleClass["Warrior"], "T3Warrior" },
    },
    ["T4Sets"] = {
        { BabbleClass["Druid"], "T4Druid" },
        { BabbleClass["Hunter"], "T4Hunter" },
        { BabbleClass["Mage"], "T4Mage" },
        { BabbleClass["Paladin"], "T4Paladin" },
        { BabbleClass["Priest"], "T4Priest" },
        { BabbleClass["Rogue"], "T4Rogue" },
        { BabbleClass["Shaman"], "T4Shaman" },
        { BabbleClass["Warlock"], "T4Warlock" },
        { BabbleClass["Warrior"], "T4Warrior" },
    },
    ["T5Sets"] = {
        { BabbleClass["Druid"], "T5Druid" },
        { BabbleClass["Hunter"], "T5Hunter" },
        { BabbleClass["Mage"], "T5Mage" },
        { BabbleClass["Paladin"], "T5Paladin" },
        { BabbleClass["Priest"], "T5Priest" },
        { BabbleClass["Rogue"], "T5Rogue" },
        { BabbleClass["Shaman"], "T5Shaman" },
        { BabbleClass["Warlock"], "T5Warlock" },
        { BabbleClass["Warrior"], "T5Warrior" },
    },
    ["T6Sets"] = {
        { BabbleClass["Druid"], "T6Druid" },
        { BabbleClass["Hunter"], "T6Hunter" },
        { BabbleClass["Mage"], "T6Mage" },
        { BabbleClass["Paladin"], "T6Paladin" },
        { BabbleClass["Priest"], "T6Priest" },
        { BabbleClass["Rogue"], "T6Rogue" },
        { BabbleClass["Shaman"], "T6Shaman" },
        { BabbleClass["Warlock"], "T6Warlock" },
        { BabbleClass["Warrior"], "T6Warrior" },
    },
    ["ZGSets"] = {
        { BabbleClass["Druid"], "ZGDruid" },
        { BabbleClass["Hunter"], "ZGHunter" },
        { BabbleClass["Mage"], "ZGMage" },
        { BabbleClass["Paladin"], "ZGPaladin" },
        { BabbleClass["Priest"], "ZGPriest" },
        { BabbleClass["Rogue"], "ZGRogue" },
        { BabbleClass["Shaman"], "ZGShaman" },
        { BabbleClass["Warlock"], "ZGWarlock" },
        { BabbleClass["Warrior"], "ZGWarrior" },
    },
    ["ArenaPvPRewards"] = {
        { BabbleClass["Druid"], "ArenaDruid" },
        { BabbleClass["Hunter"], "ArenaHunter" },
        { BabbleClass["Mage"], "ArenaMage" },
        { BabbleClass["Paladin"], "ArenaPaladin" },
        { BabbleClass["Priest"], "ArenaPriest" },
        { BabbleClass["Rogue"], "ArenaRogue" },
        { BabbleClass["Shaman"], "ArenaShaman" },
        { BabbleClass["Warlock"], "ArenaWarlock" },
        { BabbleClass["Warrior"], "ArenaWarrior" },
        { AL["Arena PvP Weapons"], "ArenaWeapons" },
    },
    ["Arena2PvPRewards"] = {
        { BabbleClass["Druid"], "Arena2Druid" },
        { BabbleClass["Hunter"], "Arena2Hunter" },
        { BabbleClass["Mage"], "Arena2Mage" },
        { BabbleClass["Paladin"], "Arena2Paladin" },
        { BabbleClass["Priest"], "Arena2Priest" },
        { BabbleClass["Rogue"], "Arena2Rogue" },
        { BabbleClass["Shaman"], "Arena2Shaman" },
        { BabbleClass["Warlock"], "Arena2Warlock" },
        { BabbleClass["Warrior"], "Arena2Warrior" },
        { AL["Arena 2 PvP Weapons"], "Arena2Weapons" },
    },
    ["AVRewards"] = {
        { AL["Misc. Rewards"], "AVMisc" },
        { AL["Superior Rewards"], "AVBlue" },
        { AL["Epic Rewards"], "AVPurple" },
    },
    ["ABRewards"] = {
        { AL["Misc. Rewards"], "ABMisc" },
        { AL["Superior Rewards"], "ABBlue" },
        { AL["Epic Rewards"], "ABPurple" },
    },
    ["ABSets"] = {
        { AtlasLoot_TableNames["ABSets1"][1], "ABSets1" },
        { AtlasLoot_TableNames["ABSets2"][1], "ABSets2" },
    },
    ["PvPLvl60Access"] = {
        { AtlasLoot_TableNames["PvP60Accessories1"][1], "PvP60Accessories1" },
        { AtlasLoot_TableNames["PvP60Accessories2"][1], "PvP60Accessories2" },
        { AtlasLoot_TableNames["PvP60Accessories3"][1], "PvP60Accessories3" },
    },
    ["PvPLvl70Access"] = {
        { AtlasLoot_TableNames["PvP70Accessories1"][1], "PvP70Accessories1" },
        { AtlasLoot_TableNames["PvP70Accessories2"][1], "PvP70Accessories2" },
    },
    ["PvPNonSetEpic"] = {
        { AtlasLoot_TableNames["PvP70NonSet1"][1], "PvP70NonSet1" },
        { AtlasLoot_TableNames["PvP70NonSet2"][1], "PvP70NonSet2" },
        { AtlasLoot_TableNames["PvP70NonSet3"][1], "PvP70NonSet3" },
        { AtlasLoot_TableNames["PvP70NonSet4"][1], "PvP70NonSet4" },
        { AtlasLoot_TableNames["PvP70NonSet5"][1], "PvP70NonSet5" },
    },
    ["PvPLvl60Rewards"] = {
        { BabbleClass["Druid"], "PVPDruid" },
        { BabbleClass["Hunter"], "PVPHunter" },
        { BabbleClass["Mage"], "PVPMage" },
        { BabbleClass["Paladin"], "PVPPaladin" },
        { BabbleClass["Priest"], "PVPPriest" },
        { BabbleClass["Rogue"], "PVPRogue" },
        { BabbleClass["Shaman"], "PVPShaman" },
        { BabbleClass["Warlock"], "PVPWarlock" },
        { BabbleClass["Warrior"], "PVPWarrior" },
        { AtlasLoot_TableNames["PVPWeapons1"][1], "PVPWeapons1" },
        { AtlasLoot_TableNames["PVPWeapons2"][1], "PVPWeapons2" },
    },
    ["PvPLvl70Rewards"] = {
        { BabbleClass["Druid"], "PVP70Druid1" },
        { BabbleClass["Hunter"], "PVP70Hunter" },
        { BabbleClass["Mage"], "PVP70Mage" },
        { BabbleClass["Paladin"], "PVP70Paladin1" },
        { BabbleClass["Priest"], "PVP70Priest" },
        { BabbleClass["Rogue"], "PVP70Rogue" },
        { BabbleClass["Shaman"], "PVP70Shaman1" },
        { BabbleClass["Warlock"], "PVP70Warlock" },
        { BabbleClass["Warrior"], "PVP70Warrior" },
        { AtlasLoot_TableNames["PVP70Weapons1"][1], "PVP70Weapons1" },
        { AtlasLoot_TableNames["PVP70Weapons2"][1], "PVP70Weapons2" },
    },
    ["WSGRewards"] = {
        { AL["Misc. Rewards"], "WSGMisc" },
        { AL["Superior Rewards"], "WSGBlue" },
        { AL["Epic Rewards"], "WSGPurple" },
    },
};


